/* ************************************************************************** */
/* Example of a syndication feed reader using the Project Rome API            */
/* current version of Rome: rome1.0.jar            https://rome.dev.java.net/ */
/* You need to implement this API plus the JDOM API                           */
/* jdom.jar  ,   you can find this at               https://jdom.org/         */
/* Parts of this example are taken from the PRome Web Page tutorials          */
/* https://rome.dev.java.net/  author:   Alejandro Abdelnur                   */
/*                                                                            */
/* This class retrieves a syndfeed from the web and prints its                */
/* pure content to the system                                                 */
/* created by Martin Stoppacher       date:  26.12.2009                       */
/* license:    LGPL 3.0                                                       */
/*             (Lesser Gnu Public License version 3.0),                       */
/*             cf. <http://www.gnu.org/licenses/lgpl.html>                    */
/* ************************************************************************** */

import java.net.URL;
/* Class URL represents a Uniform Resource Locator, a pointer to a "resource" */
/* on the World Wide Web                                                      */
import java.io.InputStreamReader;
/* An InputStreamReader is a bridge from byte streams to character streams    */
import com.sun.syndication.feed.synd.SyndFeed;
/* This is the Bean interface for all types of feeds.                         */
import com.sun.syndication.io.SyndFeedInput;
/* Parses an XML document (File, InputStream, Reader, W3C SAX InputSource, W3C*/
/* DOM Document or JDom DOcument) into an WireFeed (RSS/Atom).                */
import com.sun.syndication.io.XmlReader;
/* Character stream that handles (or at least attemtps to) all the necessary  */
/* Voodo to figure out the charset encoding of the XML document within        */
/* the stream.                                                                */

public class 1_FeedReader {

    public static void main(String[] args) {
        boolean ok = false;
        if (args.length==1) {
            try {
                URL feedUrl = new URL(args[0]);/*creates a string with the URL*/

                SyndFeedInput input = new SyndFeedInput(); /* new input object*/
                SyndFeed feed = input.build(new XmlReader(feedUrl));
                
                                  /* reads feed from URL and puts it into feed*/

                System.out.println(feed);           /* outputs file to system */

                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("ERROR: "+ex.getMessage());
            }
        }

      if (!ok) {
      System.out.println();
      System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
      System.out.println("The first parameter must be the" 
                                              +"URL of the feed to read.");
      
      System.out.println();
      }
    }

}